package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.util.List;

/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 结算单号 精确 */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /** 结算单名称 精确 */
    @ApiModelProperty("结算单名称")
    private String settleName;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 申请人ID 精确 */
    @ApiModelProperty("申请人ID")
    private Long applyUserId;
    /** 申请人部门ID 精确 */
    @ApiModelProperty("申请人部门ID")
    private Long applyUserBuId;
    /** 单据状态 精确 */
    @ApiModelProperty("单据状态")
    private String status;
    /** 结算人天 精确 */
    @ApiModelProperty("结算人天")
    private Integer settleDays;
    /** 相关附件 精确 */
    @ApiModelProperty("相关附件")
    private String fileCodes;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字4 精确 */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /** 扩展字5 精确 */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
