package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
public interface SettleApplyDetailsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link SettleApplyDetailsVO}>
     */
    PagingVO<SettleApplyDetailsVO> queryPaging(SettleApplyDetailsQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SettleApplyDetailsVO}>
     */
    List<SettleApplyDetailsVO> queryListDynamic(SettleApplyDetailsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link SettleApplyDetailsVO}
     */
    SettleApplyDetailsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SettleApplyDetailsVO}
     */
    SettleApplyDetailsVO insert(SettleApplyDetailsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SettleApplyDetailsVO}
     */
    SettleApplyDetailsVO update(SettleApplyDetailsPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(SettleApplyDetailsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 结算申请-关联资源查询
     *
     * @folder 关联资源查询
     * @param userId 资源id
     * @param settleStartDate 结算开始日期
     * @param settleEndDate 结算结束日期
     */
    PurchaseAgreementResVO queryAssocationResoure(Long userId, LocalDate settleStartDate, LocalDate settleEndDate);

}
