package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;


/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyDetailsVO extends BaseViewModel implements Serializable {
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long settleApplyId;
    /**
     * 采购协议ID
     */
    @ApiModelProperty("采购协议ID")
    private Long purchaseAgreementId;
    /**
     * 结算资源ID
     */
    @ApiModelProperty("结算资源ID")
    private Long settleResId;
    /**
     * 结算资源名称
     */
    @ApiModelProperty("结算资源名称")
    @UdcName(udcName = "USER", codePropName = "settleResId")
    private String settleResName;
    /**
     * 结算开始日期
     */
    @ApiModelProperty("结算开始日期")
    private LocalDate startDate;
    /**
     * 结算结束日期
     */
    @ApiModelProperty("结算结束日期")
    private LocalDate endDate;
    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String coopWay;

    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    @UdcName(udcName = "purchase:cooperation_way", codePropName = "coopWay")
    private String coopWayDesc;
    /**
     * 结算人天
     */
    @ApiModelProperty("结算人天")
    private BigDecimal settleDays;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    private BigDecimal settleAmt;
    /**
     * 出差补贴单价
     */
    @ApiModelProperty("出差补贴单价")
    private BigDecimal businessTripPrice;
    /**
     * 出差补贴总额
     */
    @ApiModelProperty("出差补贴总额")
    private BigDecimal businessTripAmt;
    /**
     * 结算总额
     */
    @ApiModelProperty("结算总额")
    private BigDecimal settlerTotalAmt;
    /**
     * 出差天数
     */
    @ApiModelProperty("出差天数")
    private BigDecimal businessTripDays;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    private String reasonNo;
    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    private String saleContractNo;
    /**
     * 子合同id
     */
    @ApiModelProperty("子合同id")
    private Long saleContractId;
    /**
     * 项目归属bu
     */
    @ApiModelProperty("项目归属bu")
    private Long projectBelongBu;

    /**
     * 项目归属bu名称
     */
    @ApiModelProperty("项目归属bu名称")
    @UdcName(udcName = "BU", codePropName = "projectBelongBu")
    private String projectBelongBuName;
    /**
     * 付款时间
     */
    @ApiModelProperty("付款时间")
    private LocalDateTime payTime;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    private BigDecimal payAmt;
    /**
     * 付款状态
     */
    @ApiModelProperty("付款状态")
    private String payStatus;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;

    // 主表字段
    //申请人
    @ApiModelProperty("申请人")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @ApiModelProperty("申请人名称")
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;

    // 申请日期
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    //结算单号
    @ApiModelProperty("结算单号")
    private String settleNo;

    // 结算单状态
    @ApiModelProperty("结算单状态")
    private String status;

    /**
     * 单据状态 udc[purchase:settle_apply:status]
     */
    @ApiModelProperty("单据状态 udc[purchase:settle_apply:status]")
    @UdcName(udcName = "purchase:settle_apply:status", codePropName = "status")
    private String statusDesc;
}
