package com.elitesland.tw.tw5.api.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRefPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRefQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;

import java.util.List;

/**
 * 短链服务关系表
 *
 * @author duwh
 * @date 2023-05-19
 */
public interface ShortUrlRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ShortUrlRefVO}>
     */
    PagingVO<ShortUrlRefVO> queryPaging(ShortUrlRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ShortUrlRefVO}>
     */
    List<ShortUrlRefVO> queryListDynamic(ShortUrlRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO queryByKey(Long key);

    /**
     * 根据短链地址识别码查询
     *
     * @param code 短链地址识别码
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO queryByCodeAndAddVisitNum(String code);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO insert(ShortUrlRefPayload payload);

    /**
     * 生成短链-重定向策略
     *
     * @param longUrlSuffix 长url后缀
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO saveRedirect(String longUrlSuffix);

    /**
     * 生成短链-重定向策略
     *
     * @param longUrlSuffix    长url后缀
     * @param shortUrlRelative 短链地址-相对地址
     * @param shortUrlPre      短url前
     * @param longUrlPre       长url前
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO saveRedirect(String longUrlSuffix, String shortUrlRelative, String shortUrlPre, String longUrlPre);

    /**
     * 生成短链-转发策略
     *
     * @param longUrlSuffix 长url后缀
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO saveForward(String longUrlSuffix);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ShortUrlRefVO}
     */
    ShortUrlRefVO update(ShortUrlRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
