package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPathExprPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigPathExprQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigPathExprVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 文档配置函数表达式
 *
 * @author wangly
 * @date 2024-07-02
 */
public interface BusinessDocTypeConfigPathExprService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeConfigPathExprVO}>
     */
    PagingVO<BusinessDocTypeConfigPathExprVO> queryPaging(BusinessDocTypeConfigPathExprQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeConfigPathExprVO}>
     */
    List<BusinessDocTypeConfigPathExprVO> queryListDynamic(BusinessDocTypeConfigPathExprQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeConfigPathExprVO}
     */
    BusinessDocTypeConfigPathExprVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigPathExprVO}
     */
    BusinessDocTypeConfigPathExprVO insert(BusinessDocTypeConfigPathExprPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigPathExprVO}
     */
    BusinessDocTypeConfigPathExprVO update(BusinessDocTypeConfigPathExprPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeConfigPathExprPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过表单名称和字段获取函数表达式
     *
     * @param tableName 表名称
     * @param tableName 表字段
     */
    BusinessDocTypeConfigPathExprVO getFunctionExpr(String tableName, String field);
}
