package com.elitesland.tw.tw5.api.prd.ab.service;


import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author carl.wang
 * @Description: 联系人管理
 * @date
 */
public interface PrdAbContactsService {
    /**
     * @param payload
     * @Description 新增地址簿和公司
     **/
    PrdAbContactsVO insert(PrdAbContactsPayload payload);

    /**
     * @param keys       主键
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @return
     * @Description 删除
     **/
    boolean delete(Long bookId, String objectType, List<Long> keys);

    /**
     * @param payload
     * @Description 修改地址簿和公司
     **/
    boolean update(PrdAbContactsPayload payload);

    /**
     * @param key    主键
     * @param status 状态
     * @return boolean
     * @Description 修改状态
     **/
    boolean updateStatus(Long key, String status);

    /**
     * @return
     * @Description 列表查询
     **/
    List<PrdAbContactsVO> queryList(Long bookId);


    /**
     * @param query
     * @return
     * @Description 分页查询
     **/
    PagingVO<PrdAbContactsVO> paging(PrdAbContactsQuery query);

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    PrdAbContactsVO queryByKey(Long key);


    /**
     * @param payload 跟进payload
     * @return
     * @Description 添加跟进动态
     **/
    void addFollow(CrmFollowPayload payload);

    /**
     * @param payload 跟进payload
     * @return
     * @Description 修改跟进动态
     **/
    void updateFollow(CrmFollowPayload payload);

    /**
     * @param objectId 商机id
     * @return
     * @Description 列表查询
     **/
    List<CrmFollowVO> queryListFollow(Long objectId);

    /**
     * 查询修改记录
     *
     * @param query 查询条件
     * @return
     */
    PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query);


    void downloadBatch(HttpServletResponse response, PrdAbContactsQuery query);
}
