package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingCheckPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
public interface AccReimSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingVO}>
     */
    PagingVO<AccReimSettingVO> queryPaging(AccReimSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingVO}>
     */
    List<AccReimSettingVO> queryListDynamic(AccReimSettingQuery query);

    /**
     * 报销配置主表-多条件查询具体配置
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingVO}>
     */
    AccReimSettingVO queryBaseSetting(AccReimSettingQuery query);

    /**
     * 报销配置主表-多条件查询具体配置
     */
    Map<String,AccReimSettingVO> queryBaseSettings(AccReimSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingVO}
     */
    AccReimSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingVO}
     */
    AccReimSettingVO insert(AccReimSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingVO}
     */
    AccReimSettingVO update(AccReimSettingPayload payload);

    /**
     * 插入配置前校验重复
     * @param payload
     */
    void checkRepeat(AccReimSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 规则检查
     * @param reimSettingCheckPayload
     * @return
     */
    Map<String,Object> ruleCheck(AccReimSettingCheckPayload reimSettingCheckPayload);
}
