package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 核算-数据处理中间层
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
public class CalResourcePriceQuery extends TwQueryParam implements Serializable {
    /**
     * 操作期间
     */
    @ApiModelProperty("操作期间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate finDate;
    /**
     * from bu_id 精确
     */
    @ApiModelProperty("from bu_id")
    private Long fromBuId;
    /**
     * to bu_id 精确
     */
    @ApiModelProperty("to bu_id")
    private Long toBuId;
    /**
     * 工种 精确
     */
    @ApiModelProperty("工种")
    private String jobType1;
    /**
     * 工种子类 精确
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
  
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 资源id 精确
     */
    @ApiModelProperty("资源id")
    private Long resId;
}
