package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;


/**
  * 礼品单明细
  *
  * @author xxb
  * @date 2023-08-31
  */
@Getter
@Setter
public class CrmGiftInfoVO extends BaseViewModel implements Serializable {
    /** 礼品单ID */
    @ApiModelProperty("礼品单ID")
    private Long giftListId;
    /** 礼品名称 */
    @ApiModelProperty("礼品名称")
    private String giftName;
    /** 申请数量 */
    @ApiModelProperty("申请数量")
    private String giftNumber;
    /** 单位 */
    @ApiModelProperty("单位")
    private String giftUnit;
    /** 客户方 */
    @ApiModelProperty("客户方")
    private Long customerId;
    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String custName;
    /** 客户方地址 */
    @ApiModelProperty("客户方地址")
    private String custAddress;
    /** 客户经营部门 */
    @ApiModelProperty("客户经营部门")
    private String custOperBu;
    /** 岗位情况 */
    @ApiModelProperty("岗位情况")
    private String jobDetail;
    /** 联系方式 */
    @ApiModelProperty("联系方式")
    private String mobile;
    /** 礼品寄送地址 */
    @ApiModelProperty("礼品寄送地址")
    private String locationDetail;
    /** 赠送理由 */
    @ApiModelProperty("赠送理由")
    private String reason;
    @ApiModelProperty("经营人脉主键")
    private Long peopleId;
    /** 经营人脉 */
    @ApiModelProperty("经营人脉")
    private String peopleName;

    /**
     * 礼品单编号
     */
    @ApiModelProperty("礼品单编号")
    private String giftNo;

    /**申请用户ID*/
    @ApiModelProperty("申请用户ID")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUser;

    /**申请人bu*/
    @ApiModelProperty("申请人bu")
    private Long applyUserBuId;
    @UdcName(udcName = "BU", codePropName = "applyUserBuId")
    @ApiModelProperty("申请BU_Name")
    private String applyUserBuName;

    /**创建人bu*/
    @ApiModelProperty("创建人bu")
    private Long createUserBuId;
    @UdcName(udcName = "BU", codePropName = "createUserBuId")
    @ApiModelProperty("创建人BU_Name")
    private String createUserBuName;

    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 特殊申请用户标志
     */
    @ApiModelProperty("特殊申请用户标志")
    private Integer specialUsersFlag;

    /**
     * 礼品类型 一级
     */
    @ApiModelProperty("礼品类型 一级")
    private String giftType1;
    /**
     * 礼品类型 二级
     */
    @ApiModelProperty("礼品类型 二级")
    private String giftType2;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 礼品类型 一级
     */
    @ApiModelProperty("礼品类型 一级")
    private String giftTypeName1;
    /**
     * 礼品类型 二级
     */
    @ApiModelProperty("礼品类型 二级")
    private String giftTypeName2;

    @ApiModelProperty("申请状态")
    private String applyStatusName;

    @ApiModelProperty("礼品类型")
    private String giftTypeName;

}
