package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Data
public class CrmLeadsListVO extends BaseViewModel {

//    /**
//     * 近海
//     */
//    private List<CrmOffshoreListVO> offshores;

    /**
     * 从近海维度查询，近海唯一
     */
    private CrmOffshoreListVO offshore;

    /**
     * 线索标签
     */
    private List<PrdSystemTagVO> leadsTags;
    private String leadsTagIds;

    /**
     * 从近海维度查询，近海唯一
     */
    private Long offshoreId;
    private List<Long> offshoreIds;

    /**
     * 线索编号
     */
    private String leadsNo;

    /**
     * 线索名称
     */
    private String leadsName;

    /**
     * 线索状态
     */
    private String leadsStatus;
    private String leadsStatusDesc;


    /**
     * 线索阶段
     */
    private String leadsStage;
    private String leadsStageDesc;


    /**
     * 分配日期
     */
    private LocalDate distributeDate;

    /**
     * 来源类型
     */
    private String sourceType;
    private String sourceTypeDesc;

    /**
     * 市场活动项目id
     */
    private PrjProjectVO market;


    /**
     * 市场渠道
     */
    private String marketChannel;
    private String marketChannelDesc;
    /**
     * 渠道
     */
    private String channel;

    /**
     * 需求产品
     */
    private String demandProduct;
    private String demandProductDesc;

    /**
     * 需求产品部门
     */
    private Long demandProductOrg;
    private String demandProductOrgName;

    /**
     * 销售负责人
     */
    private Long saleUserId;
    private String saleEmployeeNo;
    private String saleUserName;

    /**
     * 销售负责人所属部门
     */
    private Long saleUserBuId;
    private String saleUserBuName;

    /**
     * 上一任负责人
     */
    private Long preSaleUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 来源人
     */
    private Long sourceUserId;
    private String sourceEmployeeNo;
    private String sourceUserName;

    /**
     * 关闭原因
     */
    private String closeReason;


    /**
     * 线索客户
     */
    private CrmLeadsCustomerVO customer;

    /**
     * 最新跟进情况
     */
    private CrmFollowVO follow;

    /**
     * 预留字段1
     */
    private String extString1;

    /**
     * 预留字段2
     */
    private String extString2;

    /**
     * 预留字段3
     */
    private String extString3;

    /**
     * 预留字段4
     */
    private String extString4;

    /**
     * 预留字段5
     */
    private String extString5;

    private String annualTurnover;

    private String annualTurnoverDesc;

    /**
     * 城市
     */
    private String area;

    /**
     * 城市中文
     */
    private String areaName;

    /**
     * 是否时导出操作
     */
    private Boolean dumpFlag;
}

