package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
@Getter
@Setter
public class AbnormalWorkApplyConfigQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 事由类型 精确 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 触发条件 精确 */
    @ApiModelProperty("触发条件")
    private String triggerCondition;
    /** 触发天数 精确 */
    @ApiModelProperty("触发天数")
    private BigDecimal conditionDays;
    /** 业务角色1 精确 */
    @ApiModelProperty("业务角色1")
    private String firstRoleType;
    /** 审批角色1 精确 */
    @ApiModelProperty("审批角色1")
    private String firstApprovePerson;
    /** 业务角色2 精确 */
    @ApiModelProperty("业务角色2")
    private String twiceRoleType;
    /** 审批角色2 精确 */
    @ApiModelProperty("审批角色2")
    private String twiceApprovePerson;
    /** 业务角色3 精确 */
    @ApiModelProperty("业务角色3")
    private String thirdRoleType;
    /** 审批角色3 精确 */
    @ApiModelProperty("审批角色3")
    private String thirdApprovePerson;
    /** 业务角色4 精确 */
    @ApiModelProperty("业务角色4")
    private String fourthRoleType;
    /** 审批角色 精确 */
    @ApiModelProperty("审批角色4")
    private String fourthApprovePerson;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
