package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Getter
@Setter
public class TBusiCardApplyVO extends BaseViewModel implements Serializable {
    /**
     * 英文名
     */
    @ApiModelProperty("英文名")
    private String eName;
    private String englishName;
    /**
     * BaseBU
     */
    @ApiModelProperty("BaseBU")
    private Long basebuId;
    @UdcName(udcName = "BU", codePropName = "basebuId")
    private String basebuName;
    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private Long ouId;
    @ApiModelProperty("所属公司")
    private String ouName;
    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;
    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;
    /**
     * 中文抬头
     */
    @ApiModelProperty("中文抬头")
    private String cTitle;
    private String chineseTitle;
    /**
     * 英文抬头
     */
    @ApiModelProperty("英文抬头")
    private String eTitle;
    private String englishTitle;
    /**
     * 邮件标志
     */
    @ApiModelProperty("邮件标志")
    private String mailFlag;
    private String mailFlagDesc;
    /**
     * 名片邮寄地址
     */
    @ApiModelProperty("名片邮寄地址")
    private String mailAddr;
    /**
     * 申请结果
     */
    @ApiModelProperty("申请结果")
    private String applyResult;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
