package com.elitesland.tw.tw5.api.prd.partner.team.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;

import java.util.List;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessTeamMemberService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessTeamMemberVO}>
     */
    PagingVO<BusinessTeamMemberVO> queryPaging(BusinessTeamMemberQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessTeamMemberVO}>
     */
    List<BusinessTeamMemberVO> queryListDynamic(BusinessTeamMemberQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessTeamMemberVO}
     */
    BusinessTeamMemberVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessTeamMemberVO}
     */
    List<BusinessTeamMemberVO> insert(List<BusinessTeamMemberPayload> payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessTeamMemberVO}
     */
    BusinessTeamMemberVO update(BusinessTeamMemberPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys,Long objectId);

    /**
     * 保存
     *
     * @param payload 单据数据
     */
    BusinessTeamMemberVO save(BusinessTeamMemberPayload payload);

    /**
     * 批量保存
     *
     * @param payloadList 单据数据
     */
    List<BusinessTeamMemberVO> saveAll(List<BusinessTeamMemberPayload> payloadList);

    /**
     * 根据objectId和角色查询对应的团队成员
     *
     * @param objectId 业务主键
     * @param role 角色
     */
    List<BusinessTeamMemberVO> queryByObjectIdAndRole(Long objectId,String role);


    /**
     * 根据角色查询对应的团队成员
     *
     * @param objectIds 业务主键
     * @param role 角色
     */
    List<BusinessTeamMemberVO> queryByObjectIdsAndRole(List<Long> objectIds,String role);


    /**
     * 根据objectId查询对应的团队成员
     *
     * @param objectId 业务主键
     */
    List<BusinessTeamMemberVO> queryByObjectId(Long objectId);

    /**
     * 查询数量
     *
     * @param query 单据数据
     * @return Long 条数
     */

    Long count(BusinessTeamMemberQuery query);
    /**
     * 根据objectId和身份更新对应的团队成员角色
     *
     * @param objectId 业务主键
     * @param identity 身份
     */
    void updateTeamByIdentityChange(Long objectId,String identity);

    /**
     * 根据objectId删除团队成员
     *
     * @param objectId 业务主键
     */
    void deleteByObjectId(Long objectId);
    /**
     * 根据objectId和角色类型删除团队成员
     *
     * @param objectId 业务主键
     * @param type 类型
     * @param memberRoles 角色集合
     */
    void deleteTeamMember(Long objectId,String type,List<String> memberRoles);
}
