package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
@Getter
@Setter
public class PmsProjectEventLogPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * 事件内容及来源
     */
    @ApiModelProperty("事件内容及来源")
    private String eventContentSource;
    /**
     * 可能产生的影响
     */
    @ApiModelProperty("可能产生的影响")
    private String possibleImpacts;
    /**
     * 所属类型
     */
    @ApiModelProperty("所属类型")
    private String type;
    /**
     * 严重程度
     */
    @ApiModelProperty("严重程度")
    private String severity;
    /**
     * 发生几率
     */
    @ApiModelProperty("发生几率")
    private String probabilityOfOccurrence;
    /**
     * 风险程度
     */
    @ApiModelProperty("风险程度")
    private String riskLevel;
    /**
     * 应对策略
     */
    @ApiModelProperty("应对策略")
    private String copingStrategy;
    /**
     * 预计结束时间
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate expectedEndDate;
    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long headResId;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;
    /**
     * 完成时间
     */
    @ApiModelProperty("完成时间")
    private LocalDateTime finishTime;
}
