package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 资源计划人天明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanDaysPayload extends TwCommonPayload  implements Serializable {
    /** 关联资源计划ID */
    @ApiModelProperty("关联资源计划ID")
    private Long planId;
    /** 规划角色明细ID */
    @ApiModelProperty("规划角色明细ID")
    private Long roleDetailId;

    /** 规划工作天数 */
    @ApiModelProperty("规划工作天数")
    private BigDecimal days;

    /** 开始时间 */
    @ApiModelProperty("开始时间")
    private LocalDate startDate;
}
