package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Getter
@Setter
public class PmsProjectMembersQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 项目ID 精确 */
    @ApiModelProperty("项目ID")
    private Long projId;
    /** 角色 精确 */
    @ApiModelProperty("角色")
    private String role;
    /** 复合能力ID 精确 */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    /** 资源id 精确 */
    @ApiModelProperty("资源id")
    private Long resId;
    /** 预计开始日期 精确 */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /** 预计结束日期 精确 */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /** 规划当量 精确 */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;
    /** 工作台默认显示 精确 */
    @ApiModelProperty("工作台默认显示")
    private Integer workbenchFlag;
    /** 客户结算价 精确 */
    @ApiModelProperty("客户结算价")
    private BigDecimal customerPrice;
}
