package com.elitesland.tw.tw5.api.prd.ts.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Getter
@Setter
public class TsApprovalConfigPayload extends TwCommonPayload implements Serializable {
    /**
     * 年度
     */
    @ApiModelProperty("年度")
    private Integer finYear;
    /**
     * 成本级别
     */
    @ApiModelProperty("成本级别")
    private String costLevel;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 交付bu_id
     */
    @ApiModelProperty("交付bu_id")
    private Long deliBuId;
    /**
     * 资源类型
     */
    @ApiModelProperty("资源类型")
    private String resType;
    /**
     * 预算类型（风险等级1，百分比2）
     */
    @ApiModelProperty("预算类型（风险等级1，百分比2）")
    private String budgetType;
    /**
     * 预算情况(风险等级)
     */
    @ApiModelProperty("预算情况(风险等级)")
    private String budgetData;
    /**
     * 预算情况(百分比)
     */
    @ApiModelProperty("预算情况(百分比)")
    private BigDecimal budgetData0;
    /**
     * 审批类型1（指定角色1，指定用户2）
     */
    @ApiModelProperty("审批类型1（指定角色1，指定用户2）")
    private String approvalType1;
    /**
     * 审批资源1
     */
    @ApiModelProperty("审批资源1")
    private String approvalSource1;
    /**
     * 审批类型2
     */
    @ApiModelProperty("审批类型2")
    private String approvalType2;
    /**
     * 审批资源2
     */
    @ApiModelProperty("审批资源2")
    private String approvalSource2;
    /**
     * 审批类型3
     */
    @ApiModelProperty("审批类型3")
    private String approvalType3;
    /**
     * 审批资源3
     */
    @ApiModelProperty("审批资源3")
    private String approvalSource3;
    /**
     * 状态标记（有效1.无效0）
     */
    @ApiModelProperty("状态标记（有效1.无效0）")
    private Integer statusFlag;
}
