package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 核算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccBusinessItemQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 预算编码 模糊
     */
    @ApiModelProperty("预算编码")
    private String businessCode;
    /**
     * 预算名称 模糊
     */
    @ApiModelProperty("预算名称")
    private String businessName;
    /**
     * 上级id 精确
     */
    @ApiModelProperty("上级id")
    private Long parentId;
    /**
     * 上级编号 精确
     */
    @ApiModelProperty("上级编号")
    private String parentCode;
    /**
     * 汇总科目（0：否，1：是） 精确
     */
    @ApiModelProperty("汇总科目（0：否，1：是）")
    private Integer sumFlag;
    /**
     * 明细账 精确
     */
    @ApiModelProperty("明细账")
    private String dtlAcc;
    /**
     * 处理码 精确
     */
    @ApiModelProperty("处理码")
    private String procCode;
    /**
     * 子账标记 精确
     */
    @ApiModelProperty("子账标记")
    private Integer ledgerFlag;
    /**
     * 子账类型 精确
     */
    @ApiModelProperty("子账类型")
    private String ledgerType;
    /**
     * 可配置字段1 精确
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2 精确
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3 精确
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4 精确
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5 精确
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;
    /**
     * 核算项目类别 精确
     */
    @ApiModelProperty("核算项目类别")
    private String businessType;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private String businessStatus;
    /**
     * 级别 精确
     */
    @ApiModelProperty("级别")
    private Integer businessLevel;
    /**
     * 大类 精确
     */
    @ApiModelProperty("大类")
    private String businessType1;
    /**
     * 明细类1 精确
     */
    @ApiModelProperty("明细类1")
    private String businessType2;
    /**
     * 明细类2 精确
     */
    @ApiModelProperty("明细类2")
    private String businessType3;

    /**
     * 模板：0 数据：1
     */
    private String downloadType;

    @ApiModelProperty("ID集合")
    private List<Long> idList;

    @ApiModelProperty("编码集合")
    private List<String> busCodeList;

}
