package com.elitesland.tw.tw5.api.prd.budget.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 当量、费用 使用明细
 */
@Getter
@Setter
public class BudgetUsageDetailsVO implements Serializable {


    @ApiModelProperty("来源类型")
    private String sourceType;


    @ApiModelProperty("单据Id")
    private Long documentId;
    @ApiModelProperty("单据编号")
    private String documentCode;
    @ApiModelProperty("单据名称")
    private String documentName;
    @ApiModelProperty("单据日期")
    private LocalDate documentDate;

    @ApiModelProperty("占用当量")
    private BigDecimal occupiedEquivalent;
    @ApiModelProperty("使用当量")
    private BigDecimal usedEquivalent;
    @ApiModelProperty("派发资源")
    private String distributeResource;
    @ApiModelProperty("接收资源")
    private String receiveResource;


    @ApiModelProperty("占用费用")
    private BigDecimal OccupancyFee;
    @ApiModelProperty("已使用费用")
    private BigDecimal AmountUsed;
    @ApiModelProperty("申请人")
    private String Applicant;


}
