package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

@Getter
@Setter
public class TAttendanceOtherQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 打卡人员 精确
     */
    @ApiModelProperty("打卡人员")
    private Long attendanceResId;
    /**
     * 打卡日期 精确
     */
    @ApiModelProperty("打卡日期")
    private LocalDate attendanceDate;
    /**
     * 上班时间 精确
     */
    @ApiModelProperty("上班时间")
    private String attendanceTimeStart;
    /**
     * 下班时间 精确
     */
    @ApiModelProperty("下班时间")
    private String attendanceTimeEnd;
    /**
     * 打卡经度 精确
     */
    @ApiModelProperty("打卡经度")
    private String attendanceSiteLongitude;
    /**
     * 打卡维度 精确
     */
    @ApiModelProperty("打卡维度")
    private String attendanceSiteLatitude;
    /**
     * 打卡位置 精确
     */
    @ApiModelProperty("打卡位置")
    private String attendanceLocation;
    /**
     * 打卡说明 精确
     */
    @ApiModelProperty("打卡说明")
    private String attendanceRemark;
    /**
     * 打卡设备 精确
     */
    @ApiModelProperty("打卡设备")
    private String attendanceDevice;
}

