package com.elitesland.tw.tw5.api.prd.pms.payload;

import cn.zhxu.bs.bean.DbIgnore;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@Getter
@Setter
public class PmsProjectPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目重要度
     */
    @ApiModelProperty("项目重要度")
    private String projectImportance;
    /**
     * 预算总人天
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 费用总成本
     */
    @ApiModelProperty("费用总成本")
    private BigDecimal totalCost;
    /**
     * 工时结算周期
     */
    @ApiModelProperty("工时结算周期")
    private String timesheetPeriod;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目状态
     */
    @ApiModelProperty("项目状态")
    private String projStatus;
    /**
     * 合同id
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 项目模板id
     */
    @ApiModelProperty("项目模板id")
    private Long projTempId;
    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    private String custIdst;
    /**
     * 客户区域
     */
    @ApiModelProperty("客户区域")
    private String custRegion;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    /**
     * 项目经理当量系数
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;
    /**
     * pmo资源负责人id
     */
    @ApiModelProperty("pmo资源负责人id")
    private Long pmoResId;
    /**
     * pmo助理资源负责人id
     */
    @ApiModelProperty("pmo助理资源负责人id")
    private Long pmoDeputyResId;
    /**
     * 总当量
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;
    /**
     * 派发当量（交付负责人-项目经理）
     */
    @ApiModelProperty("派发当量（交付负责人-项目经理）")
    private BigDecimal distEqva;
    /**
     * 派发费用（交付负责人-项目经理）
     */
    @ApiModelProperty("派发费用（交付负责人-项目经理）")
    private BigDecimal distCost;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 允许外包
     */
    @ApiModelProperty("允许外包")
    private Integer epibolyPermitFlag;
    /**
     * 允许转包
     */
    @ApiModelProperty("允许转包")
    private Integer subcontractPermitFlag;
    /**
     * 非结算活动需要审批
     */
    @ApiModelProperty("非结算活动需要审批")
    private Integer finishApproveFlag;
    /**
     * 最低保证金
     */
    @ApiModelProperty("最低保证金")
    private BigDecimal deposit;
    /**
     * 关联项目
     */
    @ApiModelProperty("关联项目")
    private Long relatedProjId;
    /**
     * 绩效规则
     */
    @ApiModelProperty("绩效规则")
    private String performanceDesc;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;

    /**
     * 差旅餐补限额
     */
    @ApiModelProperty("差旅餐补限额")
    private BigDecimal maxTravelFee;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;

    /**
     * 允许一人多任务包
     */
    @ApiModelProperty("允许一人多任务包")
    private Integer muiltiTaskFlag;
    /**
     * 完工百分比
     */
    @ApiModelProperty("完工百分比")
    private BigDecimal compPercent;
    /**
     * 项目进度状态
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    /**
     * 最新汇报时间时间
     */
    @ApiModelProperty("最新汇报时间时间")
    private LocalDateTime reportTime;
    /**
     * 自动汇报标识
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;

    /**
     * 包含客户承担费用标志
     */
    @ApiModelProperty("包含客户承担费用标志")
    private Integer containsCustomerFlag;
    /**
     * 项目难度
     */
    @ApiModelProperty("项目难度")
    private String projectDifficult;
    /**
     * zhoum 0:否 1:是
     */
    @ApiModelProperty("项目预算总开关标志 0:否 1:是")
    private Integer budgetSwitchFlag;
    /**
     * 项目活动状态
     */
    @ApiModelProperty("项目活动状态 ")
    private String projActivityStatus;
    /**
     * 项目活动审批状态
     */
    @ApiModelProperty("项目活动审批状态 ")
    private String projActivityApprStatus;
    /**
     * 关联项目编号
     */
    @ApiModelProperty("关联项目编号")
    private String relatedProjNo;
    /**
     * 产品编号
     */
    @ApiModelProperty("产品编号")
    private String productNo;

    /**
     * sow节选
     */
    @ApiModelProperty("sow节选")
    private String sowFiles;

    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;

    /**
     * 绩效附件
     */
    @ApiModelProperty("绩效附件")
    private String performanceFiles;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String projectFiles;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 帮我吧项目名称
     */
    @ApiModelProperty("帮我吧项目名称")
    private String bangwo8ProjName;

    @ApiModelProperty("是否是内部项目标志")
    private Integer innerProjectFlag = 0;

    /**
     * 研发立项附件
     */
    @ApiModelProperty("研发立项附件")
    private String researchFiles;
    /**
     * 实际开始日期
     */
    @ApiModelProperty("实际开始日期")
    private LocalDate startDate;
    /**
     * 实际结束日期
     */
    @ApiModelProperty("实际结束日期")
    private LocalDate endDate;

    /**
     * 变更中标志 0:否 1:是
     */
    @ApiModelProperty("变更中标志 0:否 1:是")
    private Integer changeFlag = 0;

    /**
     * 督导资源id
     */
    @ApiModelProperty("督导资源id")
    private Long superResId;
    /**
     * 项目风险等级
     */
    @ApiModelProperty("项目风险等级")
    private String riskLevel;

    /**
     * 预计上线日期
     */
    @ApiModelProperty("预计上线日期")
    private LocalDate planOnlineDate;

    /**
     * 项目汇报计划
     */
    @ApiModelProperty("项目汇报计划")
    private List<PmsProjectReportPlanPayload> projectReportPlanPayloads;

    /**
     * 变更删除的项目汇报计划ids
     */
    @ApiModelProperty("变更删除的项目汇报计划ids")
    private List<Long> delReportPlanIds;
    /**
     * 0:不需要提示 1:需要无合同项目激活后代办提示，2:需要预算变更代办提示
     */
    @ApiModelProperty("无合同项目激活后代办提示")
    private Integer noContractFlag;

    /**
     * 主交付BU_ID
     */
    @ApiModelProperty("主交付BU_ID")
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 销售负责人ID
     */
    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;
    /**
     * 签单buid
     */
    @ApiModelProperty("签单buid")
    private Long signBuId;
    /**
     * 科目模板id
     */
    @ApiModelProperty("科目模板id")
    private Long subjectTempId;

    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;

    /******暂时未使用字段**************/
    /**
     * 易道壳项目验收文档itemid
     */
    /**
     * 易道壳项目过程文档itemid
     */
    @ApiModelProperty("易道壳项目过程文档itemid")
    private String processDocItemId;

    @ApiModelProperty("易道壳项目验收文档itemid")
    private String acceptanceDocItemId;
    /**
     * 易道壳项目总结文档itemid
     */
    @ApiModelProperty("易道壳项目总结文档itemid")
    private String summaryDocItemId;
    /**
     * 研发补贴金额
     */
    @ApiModelProperty("研发补贴金额")
    private BigDecimal subsidyAmt;
    /**
     * 直接改为周末现场有补助（原字段：折旧月数）
     */
    @ApiModelProperty("直接改为周末现场有补助")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间
     */
    @ApiModelProperty("折旧开始时间")
    private LocalDateTime depreciationStartDate;

    /**
     * 汇报期间数
     */
    @ApiModelProperty("汇报期间数")
    private Integer reportQty;
    /**
     * 每期确认金额
     */
    @ApiModelProperty("每期确认金额")
    private BigDecimal reportPeriodAmt;
    /**
     * 汇报开始期间
     */
    @ApiModelProperty("汇报开始期间")
    private LocalDate reportStartDate;
    /**
     * 资源规划更新日期
     */
    @ApiModelProperty("资源规划更新日期")
    private LocalDateTime planUpdateDate;

    @ApiModelProperty("通用文档类型配置规则主键")
    private Long configRuleId;

    @ApiModelProperty("是否上传文档（通用文档）标记")
    private Boolean fileUploadFlag = false;

    /**
     * 成本级别
     */
    @ApiModelProperty("成本级别")
    private String costLevel;


    /**
     * JDE提交确认时间
     */
    @ApiModelProperty("JDE提交确认时间")
    private LocalDateTime jdeConfirmTime;


    /**
     * JDE凭证号
     */
    @ApiModelProperty("JDE凭证号")
    @DbIgnore
    private String jdeDocNo;

    /**
     * JDE凭证状态
     */
    @ApiModelProperty("JDE凭证状态")
    @DbIgnore
    private String jdeDocState;

    /**
     * JDE凭证失败原因
     */
    @ApiModelProperty("JDE凭证失败原因")
    @DbIgnore
    private String jdeErrMsg;


    /**
     * 摘要
     */
    @ApiModelProperty("摘要")
    private String jdeSummary;

    /**
     * 凭证日期 jdeDocTime 24/05/10
     */
    @ApiModelProperty("凭证日期 24/05/10")
    private String jdeDocTime;

}
