package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@Getter
@Setter
@ExcelIgnoreUnannotated
public class PmsProjectExcelExport implements Serializable {
    @ExcelProperty(index = 0, value = "序号")
    private String order;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    @ExcelProperty(index = 1, value = "项目编号")
    private String projNo;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @ExcelProperty(index = 2, value = "项目名称")
    private String projName;

    @ExcelProperty(index = 3, value = "工作类型")
    @ApiModelProperty("工作类型")
    private String workTypeDesc;
    @ExcelProperty(index = 4, value = "项目状态")
    private String projStatusDesc;
    /**
     * 交付BU名称
     */
    @ExcelProperty(index = 5, value = "交付BU")
    private String deliBuName;

    @ApiModelProperty("项目经理")
    @ExcelProperty(index = 6, value = "项目经理")
    private String pmResName;
    /**
     * 销售负责人名称
     */
    @ExcelProperty(index = 7, value = "销售负责人")
    private String saleManUserName;
    /**
     * 子合同编号
     */
    @ExcelProperty(index = 8, value = "子合同编号")
    private String contractNo;
    /**
     * 子合同名称
     */
    @ApiModelProperty("子合同名称")
    @ExcelProperty(index = 9, value = "子合同名称")
    private String contractName;
    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    @ExcelProperty(index = 10, value = "平台合同类型")
    private String platTypeDesc;
    /**
     * 合同总金额
     */
    @ApiModelProperty("合同总金额")
    @ExcelProperty(index = 11, value = "含税总金额")
    private BigDecimal sumAmt;
    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    @ExcelProperty(index = 12, value = "已开票金额")
    private BigDecimal invoicedAmt;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    @ExcelProperty(index = 13, value = "已收款金额")
    private BigDecimal recvedAmt;
    /**
     * 未收款金额
     */
    @ApiModelProperty("未收款金额")
    @ExcelProperty(index = 14, value = "未收款金额")
    private BigDecimal notReceivedAmt;
    /**
     * 项目风险等级
     */
    @ApiModelProperty("项目风险等级")
    @ExcelProperty(index = 15, value = "项目风险等级")
    private String riskLevelDesc;
    /**
     * 关联项目编号
     */
    @ApiModelProperty("关联项目编号")
    @ExcelProperty(index = 16, value = "关联项目编号")
    private String relatedProjNo;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    @ExcelProperty(index = 17, value = "预计开始日期")
    private String planStartDateStr;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    @ExcelProperty(index = 18, value = "预计结束日期")
    private String planEndDateStr;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    @ExcelProperty(index = 19, value = "创建日期")
    private String createTimeStr;
}
