package com.elitesland.tw.tw5.api.prd.product.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Getter
@Setter
public class PrdProductPayload extends TwCommonPayload  implements Serializable {
    /** 产品编号 */
    @ApiModelProperty("产品编号")
    private String prodNo;
    /** 产品名称 */
    @ApiModelProperty("产品名称")
    private String prodName;
    /** 产品大类;	表id，非udc */
    @ApiModelProperty("产品大类;	表id，非udc")
    private Long classId;
    /** 产品小类 */
    @ApiModelProperty("产品小类")
    private Long subClassId;
    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 供应主体类别 */
    @ApiModelProperty("供应主体类别")
    private String prodType;
    /** BUID */
    @ApiModelProperty("BUID")
    private Long buId;
    /** 产品负责人资源ID */
    @ApiModelProperty("产品负责人资源ID")
    private Long picResId;
    /** 产品供应商ID */
    @ApiModelProperty("产品供应商ID")
    private Long coopId;
    /** 状态 */
    @ApiModelProperty("状态")
    private String prodStatus;
    /** 适用行业 */
    @ApiModelProperty("适用行业")
    private String industry;
    /** 参考当量 */
    @ApiModelProperty("参考当量")
    private String refEqva;
    /** 参考价格 */
    @ApiModelProperty("参考价格")
    private String refPrice;
    /** 是否考察中 */
    @ApiModelProperty("是否考察中")
    private String inspectFlag;
    /** 考察原因描述 */
    @ApiModelProperty("考察原因描述")
    private String inspectReason;
    /** 标签 */
    @ApiModelProperty("标签")
    private String tagDesc;
    /** 提成类别 */
    @ApiModelProperty("提成类别")
    private String royaltyType;
    /** LOGO路径 */
    @ApiModelProperty("LOGO路径")
    private String logoPath;
    /** 视频路径 */
    @ApiModelProperty("视频路径")
    private String videoPath;
    /** 软著名称 */
    @ApiModelProperty("软著名称")
    private String copyrightName;
    /** 软著编号 */
    @ApiModelProperty("软著编号")
    private String copyrightCode;
    /** 软著附件 */
    @ApiModelProperty("软著附件")
    private String copyrightFileCodes;
    /** 是否有测试报告 */
    @ApiModelProperty("是否有测试报告")
    private String reportFlag;
    /** 测试报告附件 */
    @ApiModelProperty("测试报告附件")
    private String reportFileCodes;
    /** 是否有软件产品登记证 */
    @ApiModelProperty("是否有软件产品登记证")
    private String sprcFlag;
    /** 软件产品登记证名称 */
    @ApiModelProperty("软件产品登记证名称")
    private String sprcName;
    /** 件产品登记证编号 */
    @ApiModelProperty("软件产品登记证编号")
    private String sprcCode;
    /** 软著附件 */
    @ApiModelProperty("软件产品登记证附件")
    private String sprcFileCodes;
    /** 软件产品登记证书有效日期开始 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("软件产品登记证书有效日期开始")
    private LocalDate startDate;
    /** 软件产品登记证书有效日期结束 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("软件产品登记证书有效日期结束")
    private LocalDate endDate;
    /** 产品简介 */
    @ApiModelProperty("产品简介")
    private String prodDesc;
    /** 功能模块 */
    @ApiModelProperty("功能模块")
    private String functionDesc;
    /** 目标客户 */
    @ApiModelProperty("目标客户")
    private String customerDesc;
}
