package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;


/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class SettleApplyDetailsVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("id(请勿删除)")
    @ExcelProperty(value = "id",index = 0)
    private String idStr;

    public String getIdStr(){
        return id.toString();
    }
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long settleApplyId;
    /**
     * 采购协议ID
     */
    @ApiModelProperty("采购协议ID")
    private Long purchaseAgreementId;
    /**
     * 关联资源id
     */
    @ApiModelProperty("关联资源id")
    private Long purchaseAgreementResId;
    /**
     * 结算资源ID
     */
    @ApiModelProperty("结算资源ID")
    private Long settleResId;
    /**
     * 结算资源名称
     */
    @ApiModelProperty("结算资源名称")
    @UdcName(udcName = "USER", codePropName = "settleResId")
    @ExcelProperty(value = "结算资源名称",index = 3)
    private String settleResName;
    /**
     * 结算开始日期
     */
    @ApiModelProperty("结算开始日期")
    private LocalDate startDate;

    /**
     * 结算开始日期
     */
    @ApiModelProperty("结算开始日期")
    @ExcelProperty(value = "结算开始日期",index = 4)
    private String startDateStr;
    public String getStartDateStr(){
        if(startDate !=null){
            return  startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return startDateStr;
    }
    /**
     * 结算结束日期
     */
    @ApiModelProperty("结算结束日期")
    private LocalDate endDate;

    @ApiModelProperty("结算结束日期")
    @ExcelProperty(value = "结算结束日期",index = 5)
    private String endDateStr;

    public String getEndDateStr(){
        if(endDate !=null){
            return  endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return endDateStr;
    }
    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String coopWay;

    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    @UdcName(udcName = "purchase:cooperation_way", codePropName = "coopWay")
    @ExcelProperty(value = "合作方式",index = 8)
    private String coopWayDesc;
    /**
     * 结算人天
     */
    @ApiModelProperty("结算人天")
    @ExcelProperty(value = "结算人天",index = 9)
    private BigDecimal settleDays;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    @ExcelProperty(value = "结算单价",index = 12)
    private BigDecimal settlePrice;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    @ExcelProperty(value = "结算金额",index = 13)
    private BigDecimal settleAmt;

    /**
     * 出差天数
     */
    @ApiModelProperty("出差天数")
    @ExcelProperty(value = "出差结算人天",index = 14)
    private BigDecimal businessTripDays;
    /**
     * 出差补贴单价
     */
    @ApiModelProperty("出差补贴单价")
    @ExcelProperty(value = "出差补助(每天)",index = 15)
    private BigDecimal businessTripPrice;
    /**
     * 出差补贴总额
     */
    @ApiModelProperty("差补结算金额")
    @ExcelProperty(value = "差补结算金额",index = 16)
    private BigDecimal businessTripAmt;
    /**
     * 结算总额
     */
    @ApiModelProperty("结算总额")
    @ExcelProperty(value = "结算金额总计",index = 17)
    private BigDecimal settlerTotalAmt;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    @ExcelProperty(value = "事由类型",index = 7)
    private String reasonTypeDesc;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    @ExcelProperty(value = "事由号",index = 10)

    private String reasonName;
//    /**
//     * 事由号
//     */
//    @ApiModelProperty("事由号")
//    @ExcelProperty(value = "事由号",index = 6)
//    private String reasonNo;
    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    @ExcelProperty(value = "子合同编号",index = 6)
    private String saleContractNo;
    /**
     * 子合同id
     */
    @ApiModelProperty("子合同id")
    private Long saleContractId;
    /**
     * 项目归属bu
     */
    @ApiModelProperty("项目归属bu")
    private Long projectBelongBu;

    /**
     * 项目归属bu名称
     */
    @ApiModelProperty("项目归属bu名称")
    @UdcName(udcName = "BU", codePropName = "projectBelongBu")
    @ExcelProperty(value = "项目归属部门",index = 11)
    private String projectBelongBuName;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;

    // 主表字段
    //申请人
    @ApiModelProperty("申请人")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @ApiModelProperty("申请人名称")
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @ExcelProperty(value = "申请人名称",index = 1)
    private String applyUserName;

    // 申请日期
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    // 申请日期
    @ApiModelProperty("申请日期")
    @ExcelProperty(value = "申请日期",index = 2)
    private String applyDateStr;

    public String getApplyDateStr(){
        if(applyDate !=null){
            return  applyDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return applyDateStr;
    }


    //结算单号
    @ApiModelProperty("结算单号")
    @ExcelProperty(value = "结算单号",index = 18)
    private String settleNo;

    // 结算单状态
    @ApiModelProperty("结算单状态")
    private String status;

    /**
     * 单据状态 udc[purchase:settle_apply:status]
     */
    @ApiModelProperty("单据状态 udc[purchase:settle_apply:status]")
    @UdcName(udcName = "purchase:settle_apply:status", codePropName = "status")
    @ExcelProperty(value = "结算单状态",index = 19)
    private String statusDesc;

    /**
     * 付款时间
     */
    @ApiModelProperty("付款时间")
    private LocalDate payTime;

    /**
     * 付款时间
     */
    @ApiModelProperty("付款时间")
    @ExcelProperty(value = "付款时间",index = 20)
    private String payTimeStr;

    public String getPayTimeStr(){
        if(payTime !=null){
            return  payTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return payTimeStr;
    }

    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    @ExcelProperty(value = "付款金额",index = 21)
    private BigDecimal payAmt;
    /**
     * 付款状态
     */
    @ApiModelProperty("付款状态")
    @ExcelProperty(value = "付款状态",index = 22)
    private String payStatus;
}
