package com.elitesland.tw.tw5.api.prd.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;

import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
public interface TaskPackageService {

    /**
     * 初始化任务包
     *
     * @return TaskPackageVO
     */
    TaskPackageVO initTaskPackage(String reasonType, Long reasonId, Long receiverResId);

    /**
     * 根据主键 查询任务包
     *
     * @return
     */
    TaskPackageVO queryByKey(Long key, Boolean needTasks);

    /**
     * 通过成员添加任务包
     *
     * @param taskPackagePayload 任务包数据
     */
    TaskPackageVO addTaskPackageByMember(TaskPackagePayload taskPackagePayload);

    /**
     * 添加任务包
     *
     * @param taskPackagePayload 任务包数据
     */
    TaskPackageVO addTaskPackage(TaskPackagePayload taskPackagePayload);

    /**
     * 任务包列表
     *
     * @param taskPackageQuery
     * @return
     */
    List<TaskPackageVO> taskPackageList(TaskPackageQuery taskPackageQuery);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskSettleTimesheetVO}>
     */
    PagingVO<TaskPackageVO> queryPaging(TaskPackageQuery query);

    /**
     * 任务包数量
     *
     * @param taskPackageQuery
     * @return
     */
    long taskPackageCount(TaskPackageQuery taskPackageQuery);

    /**
     * 我的任务包列表
     *
     * @param taskPackageQuery
     * @return
     */
    List<TaskPackageVO> taskMyPackageList(TaskPackageQuery taskPackageQuery);
    List<TaskPackageVO> taskMyPackageListDib(TaskPackageQuery taskPackageQuery);

    /**
     * 更新
     *
     * @param payload
     * @return
     */
    long updateByKeyDynamic(TaskPackagePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
