package com.elitesland.tw.tw5.api.prd.budget.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2024/9/5
 */
@Data
@AllArgsConstructor
public class BudgetSummaryResultVO implements Serializable {

    @ApiModelProperty("总使用金额")
    private BigDecimal totalUsedAmt;

    @ApiModelProperty("总占用金额")
    private BigDecimal totalOccupyAmt;

    public void add(BudgetSummaryResultVO other) {
        this.totalUsedAmt = this.totalUsedAmt.add(other.totalUsedAmt);
        this.totalOccupyAmt = this.totalOccupyAmt.add(other.totalOccupyAmt);
    }

}
