package com.elitesland.tw.tw5.api.prd.budget.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 预算单据关联管理
 *
 * @author sunxw
 * @date 2024-09-05
 */
@Getter
@Setter
public class PmsBudgetDocRelateVO extends BaseViewModel implements Serializable {
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    private Long relateDocId;
    /**
     * 来源单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String relateDocType;
    /**
     * 事由ID
     */
    @ApiModelProperty("事由ID")
    private Long reasonId;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 核算项目ID
     */
    @ApiModelProperty("核算项目ID")
    private Long busItemId;
    /**
     * 占用金额
     */
    @ApiModelProperty("占用金额")
    private BigDecimal occupyAmt;
    /**
     * 已使用金额
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmt;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String extString1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String extString2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String extString3;
}
