package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Getter
@Setter
public class CalNormSettleVO extends BaseViewModel implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    @UdcName(udcName = "CAL:SETTLE:STATUS", codePropName = "settleStatus")
    private String settleStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusDesc;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 单据创建类型
     */
    @ApiModelProperty("单据创建类型")
    private String createType;
    @UdcName(udcName = "CAL:SETTLE:CREATE_TYPE", codePropName = "createType")
    private String createTypeDesc;
    /**
     * 业务类型
     */
    @ApiModelProperty("业务类型")
    private String busiType;
    @UdcName(udcName = "CAL:SETTLE:NORM", codePropName = "busiType")
    private String busiTypeDesc;
    /**
     * 相关业务单据号
     */
    @ApiModelProperty("相关业务单据号")
    private String relevNo;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;
    /**
     * 申请资源id
     */
    @ApiModelProperty("申请资源id")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /**
     * 结算日期
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 子合同id
     */
    @ApiModelProperty("子合同id")
    private Long contractId;
    private String contractName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    private String projName;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 收入方账户
     */
    @ApiModelProperty("收入方账户")
    private String inAccount;
    /**
     * 收入方科目
     */
    @ApiModelProperty("收入方科目")
    private String inAcc;
    /**
     * 支出方账户
     */
    @ApiModelProperty("支出方账户")
    private String outAccount;
    /**
     * 支出方科目
     */
    @ApiModelProperty("支出方科目")
    private String outAcc;
    /**
     * 收入方账户id
     */
    @ApiModelProperty("收入方账户id")
    private Long inAccountId;

    /**
     * 支出方账户id
     */
    @ApiModelProperty("支出方账户id")
    private Long outAccountId;
    /**
     * 实际结算总额
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    /**
     * 收款计划id
     */
    @ApiModelProperty("收款计划id")
    private Long recvplanId;
    /**
     * 收款阶段（冗余）
     */
    @ApiModelProperty("收款阶段（冗余）")
    private String receStage;
}
