package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempDetailVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 客户经营-经营计划模板明细
 *
 * @author duwh
 * @date 2022/11/17
 */
public interface CrmOperationPlanTempDetailService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanTempDetailVO}
     */
    CrmOperationPlanTempDetailVO insert(CrmOperationPlanTempDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanTempDetailVO}
     */
    CrmOperationPlanTempDetailVO update(CrmOperationPlanTempDetailPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmOperationPlanTempDetailVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmOperationPlanTempDetailVO}>
     */
    List<CrmOperationPlanTempDetailVO> queryList(CrmOperationPlanTempDetailQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmOperationPlanTempDetailVO> paging(CrmOperationPlanTempDetailQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 根据主表主键 逻辑删除
     *
     * @param tempId 主表主键
     */
    void deleteSoftByTempId(Long tempId);

    /**
     * 保存所有
     *
     * @param detailList 详细列表
     */
    void saveAll(List<CrmOperationPlanTempDetailPayload> detailList);
}
