package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力
 */

@Data
@ApiModel(description = "复合能力")
public class PrdCompositeAbilityQuery extends TwQueryParam {


    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String docNo;

    /**
     * 级别id
     */
    @ApiModelProperty("级别id")
    private Long levelId;

    /**
     * 级别名称
     */
    @ApiModelProperty("级别名称")
    private String levelName;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;

    /**
     * 首次审批标志
     */
    @ApiModelProperty("首次审批标志")
    private Boolean firstAuditFlag;

    /**
     * 首次审批审核人
     */
    @ApiModelProperty("首次审批审核人")
    private String firstAuditor;

    /**
     * 首次审批审核人id
     */
    @ApiModelProperty("首次审批审核人id")
    private Long firstAuditorId;

    /**
     * 首次审批审核人类型
     */
    @ApiModelProperty("首次审批审核人类型")
    private String firstAuditorType;

    /**
     * 首次审批审核人标志
     */
    @ApiModelProperty("首次审批审核人标志")
    private Boolean firstAuditorUpFlag;

    /**
     * 工种类型1
     */
    @ApiModelProperty("工种类型1")
    private String jobType1;

    /**
     * 工种类型2
     */
    @ApiModelProperty("工种类型2")
    private String jobType2;

    /**
     * 跨级别晋升标志
     */
    @ApiModelProperty("跨级别晋升标志")
    private Boolean crossLevelFlag;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal dlRatio;

    /**
     * 获得方式
     */
    @ApiModelProperty("获得方式")
    private String obtainType;

    /**
     * 能力获取审核人
     */
    @ApiModelProperty("能力获取审核人")
    private String auditor;

    /**
     * 能力获取审核人id
     */
    @ApiModelProperty("能力获取审核人id")
    private Long auditorId;

    /**
     * 能力获取审核人类型
     */
    @ApiModelProperty("能力获取审核人类型")
    private String auditorType;

    /**
     * 能力以上标志
     */
    @ApiModelProperty("能力以上标志")
    private Boolean abilityUpFlag;

    /**
     * 能力描述
     */
    @ApiModelProperty("能力描述")
    private String abilityDesc;

    /**
     * 能力名称
     */
    @ApiModelProperty("能力名称")
    private String name;

    /**
     * 主键ids
     */
    @ApiModelProperty("主键ids")
    private List<Long> ids;
}

