package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务伙伴管理-流程任务详情
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerTaskVO implements Serializable {
    /** 业务伙伴信息 */
    @ApiModelProperty("业务伙伴信息")
    private BusinessPartnerVO businessPartnerVO;

    /** 客户信息 */
    @ApiModelProperty("客户信息")
    private BusinessCustomerInfoVO businessCustomerInfoVO;

    /** 供应商信息 */
    @ApiModelProperty("供应商信息")
    private BusinessSupplierInfoVO businessSupplierInfoVO;

    /** 合作伙伴信息 */
    @ApiModelProperty("合作伙伴信息")
    private BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO;

    /** 银行账户信息 */
    @ApiModelProperty("银行账户信息")
    private List<BookAccountVO> bookAccountVOList;

    /** 开票信息 */
    @ApiModelProperty("开票信息")
    private List<BookInvoiceVO> bookInvoiceVOList;
}
