package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
 * 业务伙伴管理-业务伙伴同步JDE
 *
 * @author wly
 * @date 2023-12-07
 */
@Getter
@Setter
public class ComSyncBusinessPartnerVO extends BaseViewModel implements Serializable {
    /**
     * 合同id
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 业务伙伴id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;

    /**
     * 客户/供应商id 精确
     */
    @ApiModelProperty("客户/供应商id")
    private Long objectId;
    /**
     * 客户/供应商编号
     */
    @ApiModelProperty("客户/供应商编号")
    private String AN8;
    /**
     * 地址簿名称
     */
    @ApiModelProperty("地址簿名称")
    private String ALPH;
    /**
     * 客户/供应商名称
     */
    @ApiModelProperty("客户/供应商名称")
    private String ALKY;
    /**
     * 相关主档
     */
    @ApiModelProperty("相关主档 C是客户 V是供应商")
    private String AT1;
    /**
     * 签约公司
     */
    @ApiModelProperty("签约公司")
    private String MCU;
    /**
     * 合同税率
     */
    @ApiModelProperty("合同税率")
    private String TXA1;
    /**
     * 货币码1
     */
    @ApiModelProperty("货币码1")
    private String CRCD;
    /**
     * 货币码2
     */
    @ApiModelProperty("货币码2")
    private String CRCA;
    /**
     * 总账冲销
     */
    @ApiModelProperty("总账冲销")
    private String ARC;
    /**
     * 税说明码
     */
    @ApiModelProperty("税说明码")
    private String EXTR1;
    /**
     * 批处理方式
     */
    @ApiModelProperty("批处理方式")
    private String EDPM;
    /**
     * 状态 0失败 1成功
     */
    @ApiModelProperty("状态 0失败 1成功 ")
    private String status;
    /**
     * 执行次数
     */
    @ApiModelProperty("执行次数")
    private Integer count;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String docType;
}
