package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * BU项目管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Getter
@Setter
public class BuProjectPayload extends TwCommonPayload implements Serializable {
    /**
     * BU_ID
     */
    @ApiModelProperty("BU_ID")
    private Long buId;
    /**
     * 项目年度
     */
    @ApiModelProperty("项目年度")
    private Integer projYear;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目状态
     */
    @ApiModelProperty("项目状态")
    private String projStatus;
    /**
     * 项目模板id
     */
    @ApiModelProperty("项目模板id")
    private String projTempId;
    /**
     * 科目模板id
     */
    @ApiModelProperty("科目模板id")
    private Long subjectTempId;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    /**
     * 项目经理当量系数
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;
    /**
     * 主交付BU_ID
     */
    @ApiModelProperty("主交付BU_ID")
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 预算总人天
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 总当量
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 费用总成本（当量成本+费用总预算）
     */
    @ApiModelProperty("费用总成本（当量成本+费用总预算）")
    private BigDecimal totalCost;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 项目进度状态
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    /**
     * 自动汇报标识
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;

    @ApiModelProperty("慧通同步标记")
    private Integer hwhtSyncFlag;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
