package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;

import java.util.List;

/**
 * BU项目管理
 *
 * @author carl
 * @date 2023-11-29
 */
public interface BuProjectService {

    /**
     * 新增或编辑
     *
     * @param payload 单据数据
     * @return {@link BuProjectVO}
     */
    BuProjectVO insertOrUpdate(BuProjectPayload payload);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BuProjectVO}>
     */
    PagingVO<BuProjectVO> queryPaging(BuProjectQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BuProjectVO}>
     */
    List<BuProjectVO> queryListDynamic(BuProjectQuery query);

    List<BuProjectVO> queryListDynamicSimple(BuProjectQuery query);

    /**
     * 我的Bu项目
     *
     * @param query 查询
     * @return {@link List}<{@link BuProjectVO}>
     */
    List<BuProjectVO> listByMember(BuProjectQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BuProjectVO}
     */
    BuProjectVO queryByKey(Long key);


//    /**
//     * 逻辑删除
//     *
//     * @param keys 主键集合
//     */
//    void deleteSoft(List<Long> keys);

    /**
     * 更新慧通同步标记
     *
     * @param ids
     * @return
     */
    Long updateHwhtSyncFlag(List<Long> ids);

}
