package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
public interface PmsProjectService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectVO}>
     */
    PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectVO}>
     */
    List<PmsProjectVO> queryListDynamic(PmsProjectQuery query);


    /**
     * 通过事由id查询列表
     *
     * @param reasonIdList 事由id集合
     * @return {@link List}<{@link PmsProjectVO}>
     */
    List<PmsProjectVO> queryListByReasonIdList(List<Long> reasonIdList);
//    /**
//     * 查询授权事由列表
//     *
//     * @param query 条件参数
//     * @return {@link List}<{@link PmsProjectVO}>
//     */
//    List<PmsProjectVO> queryTaskAuthorizedProjectList(PmsProjectQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO queryByKey(Long key);

    /**
     * 单表项目查询
     *
     * @param key 钥匙
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO queryByKeySimple(Long key);

    /**
     * 单表项目查询
     *
     * @param keys 钥匙
     * @return {@link PmsProjectVO}
     */
    List<PmsProjectVO> queryByKeysSimple(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO querySimpleProjectByKey(Long key);

    /**
     * 通过合同主键查询
     *
     * @param contractId 主键
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO queryByContractId(Long contractId);

    /**
     * 通过合同主键查询
     *
     * @param contractIds 主键
     * @return {@link PmsProjectVO}
     */
    List<PmsProjectVO> queryByContractIds(List<Long> contractIds);

    /**
     * 通过主键查询客户经营信息
     *
     * @param key 主键
     * @return {@link PmsProjectVO}
     */
    CrmCustomerOperationVO queryProjectCustomerOperation(Long key);

    /**
     * 新增或全局修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO insertOrUpdate(PmsProjectPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 修改项目状态
     *
     * @param key
     * @param projStatus
     * @return
     */
    long updateProjStatus(Long key, String projStatus, Long pmResId);


    /**
     * 项目变更
     *
     * @param payload 单据数据
     * @return {@link PmsProjectVO}
     */
    PmsProjectVO updateChange(PmsProjectPayload payload);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 定时执行自动汇报计划
     */
    void projectJobHandler();

    /**
     * 查询汇报代办
     *
     * @return
     */
    List<PmsProjectVO> queryProjectBriefWork(Long userId);

    /**
     * 项目预计当量&费用待更新代办
     *
     * @return
     */
    List<PmsProjectVO> queryProjectUpdateWork();

    /**
     * 项目预计当量&费用待更新代办
     *
     * @return
     */
    long queryProjectUpdateWorkCount(Long userId);

    /**
     * 项目预算需变更代办
     *
     * @return
     */
    long queryProjectUpdateBudgetWorkCount(Long userId);

    /**
     * 项目预算需变更代办
     *
     * @return
     */
    List<PmsProjectVO> queryProjectUpdateBudgetWork();

    /**
     * 无合同入场虚拟合同激活后发起对项目的数据变更
     *
     * @param payload 单据数据
     * @return {@link PmsProjectVO}
     */
    void updateNoContractData(PmsProjectPayload payload);

    /**
     * 预算变更后项目标识变更
     *
     * @param key 单据数据
     * @return {@link PmsProjectVO}
     */
    void updateBudgetAfterUpdateProject(Long key);

    /**
     * 需要无合同激活的时候调用
     * 无合同入场虚拟合同激活
     *
     * @param contractId 合同id
     * @return {@link PmsProjectVO}
     */
    void noContractActivity(Long contractId);

    /**
     * 初始化历史激活项目结算单
     */
    void initWideSettle();


    /**
     * 根据项目成员查询所有项目
     *
     * @param userId
     * @return
     */
    List<PmsProjectVO> queryListByProjectMember(Long userId, Boolean selectAll);

    /**
     * 项目结项创建泛用结算单
     *
     * @param projectId 项目主键
     */
    void createProjFinishWideSettle(Long projectId);

    /**
     * 项目状态暂挂或激活
     *
     * @param projectId
     */
    void updateProjectStatus(Long projectId);

    /**
     * 项目结项使用
     *
     * @param projectIds
     * @param status
     */
    void updateProjectCloseStatus(List<Long> projectIds, String status);

    /**
     * 通过项目编号查询项目ID
     *
     * @param projectNo 项目编号
     * @return 项目Id
     */
    PmsProjectVO findIdByNo(String projectNo);

    /**
     * 根据客户id查询项目数量
     *
     * @param customerId
     * @return
     */
    long countByCustomerId(Long customerId);

    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadBatch(HttpServletResponse response, PmsProjectQuery query);

    /**
     * 预实对照表查询
     *
     * @param key 项目表主键
     */
    Map queryPlanAndActual(Long key);

    /**
     * 自动创建项目，只组装
     *
     * @param saleConContractVO
     * @return
     */
    PmsProjectPayload autoCreateProject(SaleConContractVO saleConContractVO);

    /**
     * 更新慧通同步标记
     *
     * @param ids
     * @return
     */
    Long updateHwhtSyncFlag(List<Long> ids);
}
