package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Getter
@Setter
public class PmsDistributeVO extends BaseViewModel implements Serializable {
    /**
     * 派发类型
     */
    @ApiModelProperty("派发类型")
    private String reasonType;
    /**
     * 派发事由ID
     */
    @ApiModelProperty("派发事由ID")
    private Long reasonId;
    @ApiModelProperty("派发事由")
    private String reasonName;
    /**
     * 派发编号
     */
    @ApiModelProperty("派发编号")
    private String distNo;
    /**
     * 派发资源ID
     */
    @ApiModelProperty("派发资源ID")
    private Long disterResId;
    /**
     * 派发资源姓名
     */
    @ApiModelProperty("派发资源姓名")
    @UdcName(udcName = "USER", codePropName = "disterResId")
    private String disterResName;
    /**
     * 接收资源ID
     */
    @ApiModelProperty("接收资源ID")
    private Long receiverResId;
    @ApiModelProperty("接收资源姓名")
    @UdcName(udcName = "USER", codePropName = "receiverResId")
    private String receiverResName;
    /**
     * 派发状态
     */
    @ApiModelProperty("派发状态")
    private String distStatus;
    @UdcName(udcName = "TSK:DISTRIBUTE_STATUS", codePropName = "distStatus")
    private String distStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 派发方式
     */
    @ApiModelProperty("派发方式")
    private String distMethod;
    @ApiModelProperty("派发方式")
    @UdcName(udcName = "TSK:DISTRIBUTE_METHOD", codePropName = "distMethod")
    private String distMethodDesc;
    /**
     * 派发说明
     */
    @ApiModelProperty("派发说明")
    private String distDesc;
    /**
     * 复合能力ID
     */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    @ApiModelProperty("单项能力")
    private String capaIds;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;

    @ApiModelProperty("工作地国家")
    private String workCountry;

    @ApiModelProperty("工作地省")
    private String workProvince;

    @ApiModelProperty("现场远程")
    private String workStyle;

    @ApiModelProperty("时间要求")
    private String timeRequirement;

    @ApiModelProperty("兼职|全职")
    private String workMethod;

    @ApiModelProperty("工作地")
    private String workPlace;


    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    @ApiModelProperty("复合能力级别Desc")
    private String capasetLevelDesc;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 响应人数
     */
    @ApiModelProperty("响应人数")
    private Long repsePerson;

    /**
     * 派发id
     */
    @ApiModelProperty("派发id")
    private Long distRespondId;
    /**
     * 响应状态
     */
    @ApiModelProperty("响应状态")
    private String respStatus;
    /**
     * 响应时间
     */
    @ApiModelProperty("响应时间")
    private LocalDateTime respTime;
    /**
     * 响应描述
     */
    @ApiModelProperty("响应描述")
    private String respDesc;
    /**
     * 是否邀请
     */
    @ApiModelProperty("是否邀请")
    private Integer inviteFlag;
    /**
     * 响应资源ID
     */
    @ApiModelProperty("响应资源ID")
    private Long respondentResId;


    /**
     * 响应列表
     */
    @ApiModelProperty("响应列表")
    private List<PmsDistributeRespondVO> respondList;

    @ApiModelProperty("审批状态")
    private String procInstStatusDesc;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }

    /**
     * 指定派发的是否是同一个人
     */
    private Boolean samePeople;

    @ApiModelProperty("接收资源复合能力集合")
    private List<PrdEmployeCompositeAbilityVO> compositeAbilityVOS;

}
