package com.elitesland.tw.tw5.api.prd.task.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
@ToString
public class TaskInfoExcelExport implements Serializable {

    @ApiModelProperty("事由id")
    @ExcelIgnore
    private Long reasonId;

    @ApiModelProperty("事由名称")
    @ExcelProperty(index = 10, value = "事由名称")
    private String reasonName;

    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    @ExcelIgnore
    private String reasonType;

    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    @ExcelProperty(index = 9, value = "事由类型")
    private String reasonTypeDesc;

    @ApiModelProperty("任务包ID")
    @ExcelIgnore
    private Long taskPackageId;

    @ApiModelProperty("任务包名称")
    @ExcelProperty(index = 11, value = "任务包名称")
    private String taskPackageName;

    @ApiModelProperty("上级任务ID")
    @ExcelIgnore
    private Long taskParentId;

    @ApiModelProperty("任务名称")
    @ExcelProperty(index = 1, value = "任务名称")
    private String taskName;

    @ApiModelProperty("任务编号")
    @ExcelProperty(index = 0, value = "任务编号")
    private String taskNo;

    @ApiModelProperty("任务负责人")
    @ExcelIgnore
    private Long taskResId;

    @UdcName(udcName = "USER", codePropName = "taskResId")
    @ApiModelProperty("任务负责人")
    @ExcelProperty(index = 6, value = "任务负责人")
    private String taskRes;

    @ApiModelProperty("任务派发资源id")
    @ExcelIgnore
    private Long disterResId;

    @UdcName(udcName = "USER", codePropName = "disterResId")
    @ApiModelProperty("任务派发资源")
    @ExcelProperty(index = 7, value = "任务派发资源")
    private String disterResName;

    @ApiModelProperty("协助人")
    @ExcelIgnore
    private Long assId;

    @UdcName(udcName = "USER", codePropName = "assId")
    @ExcelProperty(index = 8, value = "协助人")
    @ApiModelProperty("协助人")
    private String ass;

    @ApiModelProperty("关联活动")
    @ExcelIgnore
    private Long relatedActId;

    @ApiModelProperty("关联活动")
    @ExcelProperty(index = 12, value = "关联活动")
    private String relatedAct;

    @ApiModelProperty("计划开始日期")
    @ExcelIgnore
    private LocalDate planStartDate;

    @ExcelProperty(index = 13, value = "计划开始日期")
    private String planStartDateStr;

    @ApiModelProperty("计划结束日期")
    @ExcelIgnore
    private LocalDate planEndDate;

    @ExcelProperty(index = 14, value = "计划结束日期")
    private String planEndDateStr;

    @ApiModelProperty("任务类型")
    @ExcelProperty(index = 21, value = "任务类型")
    private String taskType;

    @UdcName(udcName = "work:assignment:assignment_type", codePropName = "taskType")
    @ExcelIgnore
    private String taskTypeDesc;

    @ApiModelProperty("任务来源类型null或1是普通任务，2奖励假任务,3帮我吧工时创建")
    @ExcelIgnore
    private String sourceType;

    @ApiModelProperty("来源id（如果是奖励假申请则是奖励假申请id）")
    @ExcelIgnore
    private Long sourceId;

    @ApiModelProperty("任务描述")
    @ExcelProperty(index = 23, value = "任务描述")
    private String taskDes;

    @ApiModelProperty("任务验收标准")
    @ExcelProperty(index = 24, value = "任务验收标准")
    private String accepCriteria;

    @ApiModelProperty("优先级")
    @ExcelProperty(index = 5, value = "优先级")
    private Integer priority;

    @ApiModelProperty("任务总当量数")
    @ExcelProperty(index = 16, value = "任务总当量数")
    private BigDecimal totalEqva;

    @ApiModelProperty("已结算当量数")
    @ExcelProperty(index = 17, value = "已结算当量数")
    private BigDecimal settledEqva;

    @ApiModelProperty("原始当量数")
    @ExcelIgnore
    private BigDecimal originalEqva;

    @ApiModelProperty("计划当量数")
    @ExcelIgnore
    private BigDecimal planEqva;

    @ApiModelProperty("追加当量数")
    @ExcelIgnore
    private BigDecimal additionEqva;

    @ApiModelProperty("拆分当量数")
    @ExcelProperty(index = 18, value = "拆分当量数")
    private BigDecimal splitEqva;

    @ApiModelProperty("已使用当量（已填工时当量）")
    @ExcelProperty(index = 19, value = "已使用当量")
    private BigDecimal usedEqva;

    @ApiModelProperty("有效当量数")
    @ExcelIgnore
    private BigDecimal validEqva;

    @ApiModelProperty("释放当量数")
    @ExcelIgnore
    private BigDecimal releaseEqva;

    @ApiModelProperty("工时已审批通过当量")
    @ExcelIgnore
    private BigDecimal approvedEqva;

    @ApiModelProperty("是否评价:1已经评价过 0没有")
    @ExcelIgnore
    private Integer evaluationflag = 0;

    @ExcelProperty(index = 22, value = "是否评价")
    private String evaluationflagStr;

    @ApiModelProperty("任务进度")
    @ExcelProperty(index = 2, value = "任务进度")
    private BigDecimal taskProgress;

    @ApiModelProperty("任务状态")
    @ExcelIgnore
    private String taskStatus;

    @UdcName(udcName = "PMS:TASK:STATUS", codePropName = "taskStatus")
    @ExcelProperty(index = 4, value = "任务状态")
    private String taskStatusDesc;

    @ApiModelProperty("是否逾期")
    @ExcelProperty(index = 3, value = "是否逾期")
    private String overdue;

    @ApiModelProperty("逾期天数")
    @ExcelIgnore
    private long overdueDays;

    @ApiModelProperty("上级任务名称")
    @ExcelProperty(index = 15, value = "上级任务名称")
    private String taskParentName;

    @ApiModelProperty("任务申请标记")
    @ExcelIgnore
    private Integer taskApplyFlag;

    @ApiModelProperty("任务申请流程Id")
    @ExcelIgnore
    private String taskApplyProcessId;


    //-----任务包中信息 ---start---
    @ApiModelProperty("发任务包资源id")
    @ExcelIgnore
    private Long disterPackegeResId;

    @ApiModelProperty("验收人")
    @ExcelIgnore
    private Long acceptorId;

    // @ApiModelProperty("验收方式")
    // private String acceptMethod;

    //-----任务包中信息 ---end---


    @ApiModelProperty("实际开始日期")
    @ExcelIgnore
    private LocalDate actualStartDate;

    @ApiModelProperty("实际结束日期")
    @ExcelIgnore
    private LocalDate actualEndDate;

    @ApiModelProperty(value = "计价方式")
    @ExcelIgnore
    private String pricingMethod;

    @ApiModelProperty("当量系数")
    @ExcelIgnore
    private BigDecimal eqvaRatio;

    /**
     * 工时填报剩余可用当量
     */
    @ApiModelProperty("工时填报剩余可用当量")
    @ExcelProperty(index = 20, value = "剩余可用当量")
    private BigDecimal effectiveEqva;

    /**
     * 当量结算单价
     */
    @ApiModelProperty(value = "当量结算单价")
    @ExcelIgnore
    private BigDecimal settlePrice;

    /**
     * 当量收入单价
     */
    @ApiModelProperty(value = "当量收入单价")
    @ExcelIgnore
    private BigDecimal incomePrice;

    /**
     * 来源帮我吧标记 1：是
     */
    @ApiModelProperty(value = "来源帮我吧标记 1：是")
    @ExcelIgnore
    private Integer bw8Flag;

    /**
     * 占用当量
     */
    @ExcelIgnore
    private BigDecimal occupyEqva = BigDecimal.ZERO;
    /**
     * 任务包状态
     */
    @ApiModelProperty(value = "任务包状态")
    @ExcelIgnore
    private String taskPackageStatus;

    @ApiModelProperty("记录创建时间")
    @ExcelIgnore
    private LocalDateTime createTime;

    @ExcelProperty(index = 25, value = "创建时间")
    @ApiModelProperty("记录创建时间")
    private String createTimeStr;
}
