package com.elitesland.tw.tw5.api.common.funConfig.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置与业务关系表
 *
 * @author duwh
 * @date 2023-12-08
 */
@Getter
@Setter
public class BusinessDocTypeRefPayload extends TwCommonPayload  implements Serializable {
    /** 易稻壳libraryId */
    @ApiModelProperty("易稻壳libraryId")
    private String libraryId;
    /** 文件夹id -yeedoc返回 */
    @ApiModelProperty("文件夹id -yeedoc返回")
    private String folderId;
    /** 文件夹名称 LeafName -yeedoc返回 */
    @ApiModelProperty("文件夹名称 LeafName -yeedoc返回")
    private String folderName;
    /** 单据主键 */
    @ApiModelProperty("单据主键")
    private Long docId;
    /** 单据类型 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @ApiModelProperty("文档类型配置主键 prd_business_doc_type_config.id")
    private Long configId;
    /** 文档类型名称（冗余）prd_business_doc_type_config.name */
    @ApiModelProperty("文档类型名称（冗余）prd_business_doc_type_config.name")
    private String configName;
    /** prd_business_doc_type_config_rule.id */
    @ApiModelProperty("prd_business_doc_type_config_rule.id")
    private Long configRuleId;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
