package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 费用报销管理明细
 *
 * @author sunxw
 * @date 2023-11-23
 */
@Data
public class AccReimDetailQuery extends TwQueryParam implements Serializable {

    @ApiModelProperty("报销单ID")
    private Long masId;

    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;

    @ApiModelProperty("费用发生地")
    private String expensePlace;

    @ApiModelProperty("核算项目")
    private Long busAccItemId;

    @ApiModelProperty("预算项目")
    private Long budgetItemId;

    @ApiModelProperty("会计科目")
    private Long finAccSubjId;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销金额(含税)")
    private BigDecimal reimAmt;

    @ApiModelProperty("支付币种")
    private String currCode;

    @ApiModelProperty("增值税税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("报销金额(不含税)")
    private BigDecimal noTaxReimAmt;

    @ApiModelProperty("外币业务")
    private Boolean foreignCurrencyFlag;

    @ApiModelProperty("原币币种")
    private String originalCurrency;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("原币币额")
    private BigDecimal originalCurrencyAmt;

    @ApiModelProperty("本币币额")
    private BigDecimal baseCurrencyAmt;

    @ApiModelProperty("发票张数")
    private Integer invoiceNum;

    @ApiModelProperty("发票金额")
    private BigDecimal invAmt;

    @ApiModelProperty("无发票原因")
    private String noinvReason;

    @ApiModelProperty("规则检查结果")
    private String checkResult;

    @ApiModelProperty("计算金额来源ID")
    private Long calcAmtSourceId;

    @ApiModelProperty("费用承担人")
    private String costPayers;

}
