package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 费用报销管理明细
 *
 * @author sunxw
 * @date 2023-11-23
 */
@Data
public class AccReimDetailVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("报销单ID")
    private Long masId;

    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;

    @ApiModelProperty("费用发生地")
    private String expensePlace;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "expensePlace")
    private String expensePlaceName;

    @ApiModelProperty("核算项目")
    private Long busAccItemId;
    private String busAccItemName;
    private String busAccItemCode;

    @ApiModelProperty("预算项目")
    private Long budgetItemId;
    private String budgetItemName;

    @ApiModelProperty("会计科目")
    private Long finAccSubjId;
    private String finAccSubjName;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销金额(含税)")
    private BigDecimal reimAmt;

    /**
     * 折扣（0~10）
     */
    @ApiModelProperty("折扣（0~10）")
    private BigDecimal invLimit;

    @ApiModelProperty("明细调整后费用")
    private BigDecimal adjustAmt;

    @ApiModelProperty("连号发票列表")
    private String continuousInvoiceNos;

    @ApiModelProperty("提醒文本")
    private String remindText;

    @ApiModelProperty("报错警告文本")
    private String errorText;

    /**
     * 报销额度
     */
    @ApiModelProperty("报销额度")
    private BigDecimal reimLimit;

    /**
     * 超额
     */
    @ApiModelProperty("超额")
    private Boolean excessLimit;
    /**
     * 抬头不一致
     */
    private Boolean notEqualFlag;

    @ApiModelProperty("逾期报销配置id")
    private Long reimSettingOverdueId;

    @ApiModelProperty("连号报销配置id")
    private Long reimSettingContinousId;

    @ApiModelProperty("报销住宿额度配置id")
    private Long reimSettingLimitId;

    @ApiModelProperty("发票抬头配置id")
    private Long reimSettingTitleId;

    @ApiModelProperty("城市级别")
    private String expensePlaceGrade;

    @ApiModelProperty("逾期报销配置")
    private AccReimSettingOverdueVO accReimSettingOverdueVO;

    @ApiModelProperty("连号报销配置")
    private AccReimSettingContinuousVO accReimSettingContinuousVO;

    @ApiModelProperty("逾期报销配置")
    private AccReimSettingLimitVO accReimSettingLimitVO;

    @ApiModelProperty("连号报销配置")
    private AccReimSettingTitleVO accReimSettingTitleVO;

    @ApiModelProperty("支付币种")
    private String currCode;

    @ApiModelProperty("增值税税率")
    private BigDecimal taxRate;
    @UdcName(udcName = "prd:ab:tax_rate", codePropName = "taxRate")
    private String taxRateName;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("报销金额(不含税)")
    private BigDecimal noTaxReimAmt;

    @ApiModelProperty("外币业务")
    private Boolean foreignCurrencyFlag;

    @ApiModelProperty("原币币种")
    private String originalCurrency;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("原币币额")
    private BigDecimal originalCurrencyAmt;

    @ApiModelProperty("本币币额")
    private BigDecimal baseCurrencyAmt;

    @ApiModelProperty("发票张数")
    private Integer invoiceNum;

    @ApiModelProperty("发票金额")
    private BigDecimal invAmt;

    @ApiModelProperty("无发票原因")
    private String noinvReason;

    @ApiModelProperty("规则检查结果")
    private String checkResult;

    @ApiModelProperty("发票集合")
    private List<InvInvoiceVO> invInvoiceList;

    @ApiModelProperty("计算金额来源ID")
    private Long calcAmtSourceId;

    @ApiModelProperty("金额计算来源详情(目前仅为餐费)")
    private AccReimSourcePayload sourcePayload;

    @ApiModelProperty("误餐费明细")
    private List<AccReimDetailMealVO> reimDetailMealVOS;

    @ApiModelProperty("费用承担人")
    private String costPayers;

    @ApiModelProperty("费用承担人")
    private String costPayersName;

    @ApiModelProperty("事由类型")
    private String reasonDetailType;

    @ApiModelProperty("事由id")
    private Long reasonDetailId;

    @ApiModelProperty("事由名称")
    private String reasonDetailName;
}
