package com.elitesland.tw.tw5.api.prd.adm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmBusitripApplyPayload extends TwCommonPayload implements Serializable {
    /**
     * 申请单名称
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 费用承担方（类型）
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;
    /**
     * 费用承担bu_id
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /**
     * 费用承担公司id
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;

    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;

    /**
     * 出发日期
     */
    @ApiModelProperty("出发日期")
    private LocalDate beginDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 天数
     */
    @ApiModelProperty("天数")
    private BigDecimal days;
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 是否行政订票
     */
    @ApiModelProperty("是否行政订票")
    private Integer bookTicketFlag;
    /**
     * 被驳回提交到提交人类型 0：其他，1：行政订票
     */
    @ApiModelProperty("被驳回提交到提交人类型 0：其他，1：行政订票")
    private Integer rejectType;

    @ApiModelProperty("报销单ID")
    private Long reimId;

    @ApiModelProperty("解绑关联的报销单 0-否 1-是")
    private Integer reimDefaultFlag;

    @ApiModelProperty("慧通同步标记")
    private Integer hwhtSyncFlag;

    @ApiModelProperty("主服务地")
    private String baseCity;

    /**
     * 出差申请详情
     */
    @ApiModelProperty("出差申请详情")
    private List<AdmBusitripApplyDetailPayload> detailPayloads;
    /**
     * 删除详情ids
     */
    @ApiModelProperty("删除详情ids")
    private List<Long> delDetailIds;

}
