package com.elitesland.tw.tw5.api.prd.adm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmBusitripApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 申请单名称 模糊
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请单号 模糊
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请状态标记（0：非等）
     */
    @ApiModelProperty("申请状态标记（0：非等）")
    private Integer applyStatusFlag;
    /**
     * 申请状态 精确
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 申请开始日期 精确
     */
    @ApiModelProperty("申请开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyBeginDate;
    /**
     * 申请结束日期 精确
     */
    @ApiModelProperty("申请结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyEndDate;

    /**
     * 事由类型 合同项目  bu项目 商机项目
     */
    @ApiModelProperty("事由类型 合同项目  bu项目 商机项目")
    private String reasonType;
    /**
     * 事由id 精确
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 申请人资源id 精确
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 费用承担方（类型） 精确
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;
    /**
     * 费用承担bu_id 精确
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /**
     * 费用承担公司id 精确
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;
    /**
     * 出发日期 精确
     */
    @ApiModelProperty("出发日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;
    /**
     * 结束日期 精确
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 天数 精确
     */
    @ApiModelProperty("天数")
    private BigDecimal days;
    /**
     * 客户id 精确
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 是否行政订票 精确
     */
    @ApiModelProperty("是否行政订票")
    private Integer bookTicketFlag;

    @ApiModelProperty("是否被报销单关联 0-未关联 1-已关联")
    private Integer reimRelateFlag;

    @ApiModelProperty("慧通同步标记")
    private Integer hwhtSyncFlag;

    @ApiModelProperty("主服务地")
    private String baseCity;

}
