package com.elitesland.tw.tw5.api.prd.adm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmBusitripApplyVO extends BaseViewModel implements Serializable {
    /**
     * 申请单名称
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    @UdcName(udcName = "ADM:BUSITRIP:STATUS", codePropName = "applyStatus")
    private String applyStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusDesc;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 事由类型  合同项目  bu项目 商机项目
     */
    @ApiModelProperty("事由类型 合同项目  bu项目 商机项目")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称（冗余字段）")
    private String reasonName;
    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /**
     * 费用承担方（类型）
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "expenseByType")
    private String expenseByTypeDesc;
    /**
     * 费用承担bu_id
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    @UdcName(udcName = "BU", codePropName = "expenseBuId")
    private String expenseBuName;
    /**
     * 费用承担公司id
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;
    private String ouName;
    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    @UdcName(udcName = "BU", codePropName = "applyBuId")
    private String applyBuName;

    /**
     * 申请人专业级别
     */
    @ApiModelProperty("申请人专业级别")
    private String applyResLevel;
    /**
     * 出发日期
     */
    @ApiModelProperty("出发日期")
    private LocalDate beginDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 天数
     */
    @ApiModelProperty("天数")
    private BigDecimal days;
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    private String custName;
    /**
     * 是否行政订票
     */
    @ApiModelProperty("是否行政订票")
    private Integer bookTicketFlag;
    /**
     * 被驳回提交到提交人类型 0：其他，1：行政订票
     */
    @ApiModelProperty("被驳回提交到提交人类型 0：其他，1：行政订票")
    private Integer rejectType;

    @ApiModelProperty("报销单Id")
    private Long reimId;

    /**
     * 出差申请详情
     */
    @ApiModelProperty("出差申请详情")
    private List<AdmBusitripApplyDetailVO> detailVOs;
    /**
     * 行政订票详情
     */
    @ApiModelProperty("行政订票详情")
    private List<AdmTripTicketVO> tripTicketVOs;

    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal recvedAmt;

    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    private String platType;

    /**
     * 项目状态
     */
    @ApiModelProperty("项目状态")
    private String projStatus;

    /**
     * 项目经理
     */
    @ApiModelProperty("项目经理")
    private Long pmResId;

    @ApiModelProperty("慧通同步标记")
    private Integer hwhtSyncFlag;

    @ApiModelProperty("主服务地")
    private String baseCity;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

}
