package com.elitesland.tw.tw5.api.prd.borrow.service;

import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
public interface TransferApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TransferApplyVO}>
     */
    PagingVO<TransferApplyVO> queryPaging(TransferApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TransferApplyVO}>
     */
    List<TransferApplyVO> queryListDynamic(TransferApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TransferApplyVO}
     */
    TransferApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TransferApplyVO}
     */
    TransferApplyVO insert(TransferApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TransferApplyVO}
     */
    TransferApplyVO update(TransferApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TransferApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
