package com.elitesland.tw.tw5.api.prd.budget.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 预算单据关联管理
 *
 * @author sunxw
 * @date 2024-09-05
 */
@Getter
@Setter
public class PmsBudgetDocRelateQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 来源单据ID 精确
     */
    @ApiModelProperty("来源单据ID")
    private Long relateDocId;
    /**
     * 来源单据类型 精确
     */
    @ApiModelProperty("来源单据类型")
    private String relateDocType;
    /**
     * 事由ID 精确
     */
    @ApiModelProperty("事由ID")
    private Long reasonId;
    /**
     * 事由类型 精确
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 核算项目ID 精确
     */
    @ApiModelProperty("核算项目ID")
    private Long busItemId;
    /**
     * 占用金额 精确
     */
    @ApiModelProperty("占用金额")
    private BigDecimal occupyAmt;
    /**
     * 已使用金额 精确
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmt;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String extString1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String extString2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String extString3;
}
