package com.elitesland.tw.tw5.api.prd.budget.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetDocRelatePayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetDocRelateQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetDocRelateVO;

import java.util.List;

/**
 * 预算单据关联管理
 *
 * @author sunxw
 * @date 2024-09-05
 */
public interface PmsBudgetDocRelateService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetDocRelateVO}>
     */
    PagingVO<PmsBudgetDocRelateVO> queryPaging(PmsBudgetDocRelateQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsBudgetDocRelateVO}>
     */
    List<PmsBudgetDocRelateVO> queryListDynamic(PmsBudgetDocRelateQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsBudgetDocRelateVO}
     */
    PmsBudgetDocRelateVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetDocRelateVO}
     */
    PmsBudgetDocRelateVO insert(PmsBudgetDocRelatePayload payload);


    /**
     * 新增
     *
     * @param payloadList 单据数据
     * @return {@link PmsBudgetDocRelateVO}
     */
    List<PmsBudgetDocRelateVO> batchInsert(List<PmsBudgetDocRelatePayload> payloadList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetDocRelateVO}
     */
    PmsBudgetDocRelateVO update(PmsBudgetDocRelatePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsBudgetDocRelatePayload payload);

    /**
     * 根据相关单据ID更新
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByRelateDocId(PmsBudgetDocRelatePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param relateDocIds 关联单据ID
     */
    void deleteByRelateDocId(List<Long> relateDocIds);

    /**
     * 逻辑删除
     *
     * @param relateDocTypes 关联单据类型
     */
    void deleteByRelateDocType(List<String> relateDocTypes);

}
