package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
@ToString
public class CalTaskSettlePayload extends TwCommonPayload implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 结算类型（任务包总价结算，任务包单价结算）
     */
    @ApiModelProperty("结算类型（任务包总价结算，任务包单价结算）")
    private String settleType;
    /**
     * 结算日期
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 验收方式
     */
    @ApiModelProperty("验收方式")
    private String acceptMethod;
    /**
     * 事由类型 01 项目 02 商机
     */
    @ApiModelProperty("事由类型 01 项目 02 商机")
    private String reasonType;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;

    /**
     * 任务包id
     */
    @ApiModelProperty("任务包id")
    private Long taskId;
    /**
     * 项目名称（冗余）
     */
    @ApiModelProperty("项目名称（冗余）")
    private String projName;
    /**
     * 任务包名称（冗余）
     */
    @ApiModelProperty("任务包名称（冗余）")
    private String taskName;
    /**
     * 支出bu_id
     */
    @ApiModelProperty("支出bu_id")
    private Long expenseBuId;
    /**
     * 收入资源id
     */
    @ApiModelProperty("收入资源id")
    private Long incomeResId;
    /**
     * 发包资源id
     */
    @ApiModelProperty("发包资源id")
    private Long disterResId;
    /**
     * 收入bu_id
     */
    @ApiModelProperty("收入bu_id")
    private Long resBuId;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;
    /**
     * 当量工资(收入单价)
     */
    @ApiModelProperty("当量工资(收入单价)")
    private BigDecimal eqvaSalary;
    /**
     * 申请结算当量数
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 实际结算当量数
     */
    @ApiModelProperty("实际结算当量数")
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 申请收入总额
     */
    @ApiModelProperty("申请收入总额")
    private BigDecimal applyIncomeAmt;
    /**
     * 实际收入总额
     */
    @ApiModelProperty("实际收入总额")
    private BigDecimal approveIncomeAmt;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 质保金比例
     */
    @ApiModelProperty("质保金比例")
    private BigDecimal guaranteeRate;
    /**
     * 质保当量
     */
    @ApiModelProperty("质保当量")
    private BigDecimal graranteeEqva;
    /**
     * 质保总额（冻结金额）
     */
    @ApiModelProperty("质保总额（冻结金额）")
    private BigDecimal graranteeAmt;
    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 评价状态
     */
    @ApiModelProperty("评价状态")
    private String evalStatus;
    /**
     * 累计提现当量
     */
    @ApiModelProperty("累计提现当量")
    private BigDecimal withdrawEqva;
    /**
     * bu累计提现当量
     */
    @ApiModelProperty("bu累计提现当量")
    private BigDecimal buWithdrawEqva;

    /**
     * 文件code
     */
    @ApiModelProperty("文件code")
    private String fileCodes;
    /**
     * 结算单明细
     */
    @ApiModelProperty("结算单明细")
    private List<CalTaskSettleDetailPayload> settleDetailPayloads;

    /**
     * 可用数量=批准结算当量-已提现当量-冻结当量
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;
    /**
     * 提现或解冻标识：（0：未操作，1：解冻中，2：提现中）
     */
    @ApiModelProperty("提现或解冻标识")
    private Integer operateFlag;
}
