package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.WorkOrderApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.WorkOrderApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkOrderApplyVO;

public interface WorkOrderApplyService {

    /**
     * 派工单申请提交
     *
     * @param payload
     * @return
     */
    void submit(WorkOrderApplyPayload payload);

    /**
     * 根据流程id查询派工单详情
     *
     * @param procId
     * @return
     */
    WorkOrderApplyVO queryByProcId(String procId);

    /**
     * 根据id查询派工单详情
     *
     * @param id
     * @return
     */
    WorkOrderApplyVO queryByKey(Long id);

    /**
     * 派工单分页查询
     *
     * @param query
     * @return
     */
    PagingVO<WorkOrderApplyVO> queryPaging(WorkOrderApplyQuery query);

}
