package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Data
public class TimesheetQuery extends TwQueryParam {
    /**
     * 填报人 精确
     */
    @Query
    private Long tsUserId;
    private String tsUserIdName;

    @Query(type = Query.Type.IN, propName = "tsUserId")
    private Set<Long> tsUserIdList;
    /**
     * 工时状态 see TimesheetStatus  精确
     */
    @Query
    private String tsStatus;

    @Query(type = Query.Type.IN, propName = "id")
    private List<Long> idList;
    /**
     * 状态  see TimesheetStatus
     */
    @Query(type = Query.Type.IN, propName = "tsStatus")
    private List<String> tsStatusList;
    /**
     * 类型 精确
     */
    @Query
    private String type;
    /**
     * 任务标识
     */
    @Query
    private String tsTaskIden;
    /**
     * 审批人 精确
     */
    @Query
    private Long apprUserId;
    /**
     * 经营计划主键 精确
     */
    @Query
    private Long operPlanId;
    /**
     * 经营计划名称 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String operPlanName;
    /**
     * 项目主键 精确
     */
    @Query
    private Long projId;

    /**
     * 项目列表
     */
    @Query(type = Query.Type.IN, propName = "projId")
    private List<Long> projIdList;
    /**
     * 项目编号 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String projNo;
    /**
     * 项目名称 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String projName;
    /**
     * 事由id
     */
    @Query
    private Long reasonId;
    @Query(type = Query.Type.IN, propName = "reasonId")
    private List<Long> reasonIdList;
    /**
     * 事由名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String reasonName;
    /**
     * 事由类型 PROJ_CONTRACT 合同项目 PROJ_OPPO 售前商机项目 PROJ_BU bu项目
     */
    @Query
    private String reasonType;

    /**
     * 项目阶段id（活动阶段）
     */
    @Query
    private Long stageId;
    /**
     * 项目阶段编号（冗余）
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String stageNo;
    /**
     * 项目阶段名称冗余
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String stageName;
    @Query
    private List<String> reasonTypes;
    /**
     * 任务包id
     */
    @Query
    private Long taskPackageId;
    /**
     * 任务包编号 冗余
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageNo;
    /**
     * 任务包名称冗余
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageName;
    /**
     * 任务主键 精确
     */
    @Query
    private Long taskId;
    /**
     * 填报人 精确
     */
    @Query
    private Long tsUserBuId;
    /**
     * 填报人所属部门 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String tsUserBuName;
    /**
     * 任务主键集合 IN
     */
    @Query(type = Query.Type.IN, propName = "taskId")
    private List<Long> taskIdList;
    /**
     * 任务编号 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskNo;
    /**
     * 任务名称 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /**
     * 任务包申请状态 精确
     */
    @Query
    private String taskApplyStatus;
    /**
     * 活动主键  精确
     */
    @Query
    private Long actId;
    /**
     * 活动名称 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String actName;
    /**
     * 活动编号 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String actNo;
    /**
     * 11上午、22下午、33全天、44自定义 精确
     */
    @Query
    private String workType;
    /**
     * 工作说明 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String workDesc;
    /**
     * 本周开始日期 精确
     */
    @Query
    private LocalDate weekStartDate;
    /**
     * 所在年周 精确
     */
    @Query
    private Integer yearWeek;
    /**
     * 结算状态 精确
     */
    @Query
    private String settleStatus;
    /**
     * 审批状态 精确
     */
    @Query
    private String apprResult;
    /**
     * 工作日期范围 BETWEEN
     */
    @Query(type = Query.Type.BETWEEN, propName = "workDate")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> workDateBetween;

    /**
     * 工作日期范围 BETWEEN
     */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> workDate;

    /**
     * 工作日期范围 BETWEEN(去除非工作日)
     */
    private Integer nonHolidayFlag;


    /**
     * 工作日期范围 BETWEEN
     */
    @Query(type = Query.Type.IN, propName = "workDate")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> workDateIn;

    /**
     * 工作日期 equal精确
     */
    @Query(type = Query.Type.EQUAL, propName = "workDate")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate workDateQuery;

    /**
     * 工作日期小于等于查询
     */
    @Query(type = Query.Type.LESS_THAN, propName = "workDate")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate workDateLessThanQuery;

    /**
     * BETWEEN
     */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> workHour;
    /**
     * BETWEEN
     */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private List<LocalDateTime> approvalTime;
    /**
     * BETWEEN
     */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> submitTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间起")
    @Query(type = Query.Type.GREATER_THAN, propName = "modifyTime")
    private LocalDateTime modifyTimeStart;

    @Query(type = Query.Type.IS_NULL, propName = "timesheetIdV4")
    private Boolean timesheetIdV4IsNull;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;

    @ApiModelProperty("部门id")
    @Query
    private Long baseCityId;

    @Query(type = Query.Type.INNER_LIKE, blurry = "taskName,projName")
    @ApiModelProperty("模糊查询")
    private String blurryQuery;

    @ApiModelProperty("活动标识")
    @Query
    private String tsActIden;

//    @ApiModelProperty("请假申请明细")
//    @Query
//    List<Long> vacationApplyDetailIds;

    /**
     * 无任务标记 null：查所有,0:查无项目无任务，1：查有项目有任务
     */
    private Integer noTaskFlag;

    @ApiModelProperty("出差城市")
    private String admCity;

}
