package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TUserVacationCancelPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TUserVacationCancelQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TUserVacationCancelVO;

import java.util.List;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
public interface TUserVacationCancelService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TUserVacationCancelVO}>
     */
    PagingVO<TUserVacationCancelVO> queryPaging(TUserVacationCancelQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TUserVacationCancelVO}>
     */
    List<TUserVacationCancelVO> queryListDynamic(TUserVacationCancelQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TUserVacationCancelVO}
     */
    TUserVacationCancelVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TUserVacationCancelVO}
     */
    TUserVacationCancelVO insertOrUpdate(TUserVacationCancelPayload payload);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TUserVacationCancelPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(TUserVacationCancelPayload payload);

}
